package college;

import java.io.File;
import java.io.FileWriter;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
import java.io.IOException;
import java.io.Writer;

/**
 *
 * @author Daryle Niedermayer, I.S.P., PMP
 * @version 1.0 2008/05/05
 * 
 */
public class PersonSet {

    Node first;
    
    /**
     * Public constructor
     */
    public PersonSet() {
        first = null;
    }
    
    /**
     * Adds a new member to the PersonSet array.
     * ASSIGNMENT 2 PART 1 
     * @param p a Person object to add to the PersonSet
     */
    public void add(Person p) {
       
        //Special case of an empty list.
        if (first == null ) {
            first = new Node(p);
        }
        //Lets prepend the new node to the start of the list
        else {
            Node newnode = new Node(p);
            newnode.link = first;
            first = newnode;
        }
        
    }

    /**
     * Prints out the NationalID, Firstname and Lastname of every non-null
     * entry in the PersonSet.
     * @throws IOException 
     */
    
    /* The following section is ASSIGNMENT 3 PART 1
    public void printSet() throws IOException {
        Node next = first;
        Writer writer = null;
        
        try {
            writer = new FileWriter("PersonList.txt",true);
            writer.write("\n");         //Print a blank line
            while (next != null) {
                writer.write(next.data.getNationalID() + " " 
                            + next.data.getFirstName() + " " + next.data.getLastName() + "\n");
                next = next.link;
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally { if (writer != null) writer.close(); }
    }
     * */
    
    /*The following section is ASSIGNMENT 3 PART 3 (with the FileOpener Class) */
    public void printSet() throws IOException {
        Node next = first;
        File file;
        FileOpener f = null;
        Writer writer = null;
        
        try {
            f = new FileOpener("PersonList.txt",true,false);
            writer = new FileWriter(f.checkFile(),true);
            writer.write("\n");         //Print a blank line
            while (next != null) {
                writer.write(next.data.getNationalID() + " " 
                            + next.data.getFirstName() + " " + next.data.getLastName() + "\n");
                next = next.link;
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally { if (writer != null) writer.close(); }
    }
    
    
    /**
     * 
     * @return the Person in the PersonSet with the oldest age
     */
    public Person getOldest() {
        Node next = first;
        Node temp = null;
        
        int count = 0;
        
        while (next != null) {
            if (count == 0 || next.data.getAge() > temp.data.getAge()) {
                temp = next;
                count++;
            }
            next = next.link;
        }
        
        if (count == 0) {
            return null;
        }
        else {
            return temp.data;
        
        }
    }
    
    /**
     * 
     * @return the Person in the PersonSet with the youngest age
     */

    public Person getYoungest() {
        Node next = first;
        Node temp = null;
        
        int count = 0;
        
        while (next != null) {
            if (count == 0 || next.data.getAge() < temp.data.getAge()) {
                temp = next;
                count++;
            }
            next = next.link;
        }
        
        if (count == 0) {
            return null;
        }
        else {
            return temp.data;
        
        }
    }
    
    public Person find(String nationalID) {
        Node next = first;
        
        while (next != null) {
            if (next.data.getNationalID() != null && next.data.getNationalID().equals(nationalID)) {
                return next.data;
            }
            else next = next.link;
        }
        
        //Person not found
        return null;
     }

        public Person find(String lastName, String firstName) {
        Node next = first;
        
        //This would be an error condition as we can't search for anyone
        if (lastName == null && firstName == null) {return null;}
        
        while (next != null) {
            if ((lastName == null || (next.data.getLastName() != null 
                        && next.data.getLastName().equals(lastName)))
                    && (firstName == null || (next.data.getFirstName() != null
                        && next.data.getFirstName().equals(firstName)))) {
                return next.data;
            }
            else next = next.link;
        }
        
        //Person not found
        return null;
     }
        
        /**
         * This method deletes a Person from the PersonSet if such a person
         * exists. It returns true if the person was deleted and false if
         * the PersonSet is empty or the Person was not found.
         * @param p Person to be deleted
         * @return true if successful; false if person not found.
         */
        public boolean delete(Person p) {
            Node next, previous;
            
            //An empty Set is a special case we need to handle
            if (first == null) {return false;}
            
            //If the deleted Person is the first node in the list,
            //we have to update the first pointer. This is a special case too.
            if (first.data == p) {
                first = first.link;
                return true;
            }
            //Otherwise, we'll set next to the second node and previous to the
            //first node. From there we step through the list, making sure
            //that previous is always one link back from next. That way we can
            //stitch up the deletion.
            else {
                next = first.link;
                previous = first;
                
                while (next != null) {
                    if (next.data == p) {
                        previous.link = next.link;
                        return true;
                    }
                    else {
                        previous = next;
                        next = next.link;
                    }
                }
                return false;
            }
            
         }


}
